package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class QueryRequest extends RequestItem
{
  public List<Integer> functions = new ArrayList<Integer>();

  public QueryRequest()
  {
    super(KMIP.Operation.Query);
  }

  public QueryRequest(List<Integer> functions)
  {
    this();
    this.functions = functions;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {

    converter.convertIntList(KMIP.Tag.QueryFunction, functions);
  }
}
