package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attributes;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class LocateRequest extends RequestItem
{

  public Integer maxItems = null;
  public Integer offsetItems = null;
  public Attributes attrs = new Attributes();

  public Integer storageStatusMask = null;
  public Integer objectGroupMember = null;

  public LocateRequest()
  {
    super(KMIP.Operation.Locate);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    maxItems = converter.convertOptional(KMIP.Tag.MaximumItems, maxItems);
    offsetItems = converter.convertOptional(KMIP.Tag.OffsetItems, offsetItems);
    storageStatusMask = converter.convertOptional(KMIP.Tag.StorageStatusMask, storageStatusMask);
    objectGroupMember = converter.convertOptional(KMIP.Tag.ObjectGroupMember, objectGroupMember);
    attrs.convert(converter);
  }
}
