package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.KeyWrappingSpec;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class GetRequest extends RequestItem
{
  public String uid = null;
  public Integer formatType = null;

  public Integer compressionType = null;
  public KeyWrappingSpec keyWrap = null;

  public String password;

  public GetRequest()
  {
    super(KMIP.Operation.Get);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    formatType = converter.convertOptional(KMIP.Tag.KeyFormatType, formatType);
    compressionType = converter.convertOptional(KMIP.Tag.KeyCompressionType, compressionType);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.KeyWrappingSpecification)
    {
      keyWrap = new KeyWrappingSpec();
    }
    if (keyWrap != null) keyWrap.convert(converter);
    password = converter.convertOptional(KMIP.Tag.DyPfxPassword, password);
  }

}
