package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class GetAttributesRequest extends RequestItem
{
  public String uid = null;
  public ArrayList<String> names = new ArrayList<String>();

  public boolean getCorrespondingKey = false;

  public GetAttributesRequest()
  {
    super(KMIP.Operation.GetAttributes);
  }

  public GetAttributesRequest(String uid)
  {
    this();
    this.uid = uid;
  }

  public GetAttributesRequest(String uid, String attribute)
  {
    this(uid);
    this.names.add(attribute);
  }

  public GetAttributesRequest(String uid, ArrayList<String> names)
  {
    this(uid);
    this.names = names;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    converter.convertStrList(KMIP.Tag.AttributeName, names);
  }
}
