package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CryptoParams;

/**
 * Created by saar.peer on 24-Jul-16.
 */
public class EncryptRequest extends RequestItem
{
  public String uid = null;
  public byte[] iv = null;
  public byte[] authEncAddData = null;
  public CryptoParams params = null;
  public byte[] data = null;
  public byte[] corr = null;
  public Boolean initInd = null;
  public Boolean finalInd = null;

  public EncryptRequest()
  {
    super(KMIP.Operation.Encrypt);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters)
      params = new CryptoParams();
    if (params != null) params.convertValue(converter);

    data = converter.convertOptional(KMIP.Tag.Data, data);
    iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, iv);
    corr = converter.convertOptional(KMIP.Tag.CorrelationValue, corr);
    initInd = converter.convertOptional(KMIP.Tag.InitIndicator, initInd);
    finalInd = converter.convertOptional(KMIP.Tag.FinalIndicator, finalInd);
    authEncAddData = converter.convertOptional(KMIP.Tag.AuthenticatedEncryptionAdditionalData, authEncAddData);
  }
}
