package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Version;

import java.util.ArrayList;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class DiscoverVersionsRequest extends RequestItem
{

  public ArrayList<Version> list = new ArrayList<Version>();

  public DiscoverVersionsRequest()
  {
    super(KMIP.Operation.DiscoverVersions);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {

    if (converter.isWrite())
    {
      for (Version version : list) version.convert(converter);
    }
    else
    {
      while (converter.getNextTag() == KMIP.Tag.ProtocolVersion)
      {
        Version version = new Version();
        version.convert(converter);
        list.add(version);
      }
    }

  }

}
