package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 23-Nov-15.
 */
public class DestroyRequest extends RequestItem
{
  public String uid = null;

  public DestroyRequest()
  {
    super(KMIP.Operation.Destroy);
  }

  public Boolean doDeleteCertificate = false;
  public Boolean doDeleteKey = false;

  public DestroyRequest(String uid)
  {
    this();
    this.uid = uid;
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    if (uid != null)
    {
      doDeleteCertificate = converter.convertOptional(KMIP.Tag.DyDeleteCertificate, doDeleteCertificate);
      if (doDeleteCertificate == null) doDeleteCertificate = false;
    }
  }
}
