package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by valery.osheter on 26-Mar-17.
 */
public class DeriveRequest extends RequestItem
{

  public int objectType = 0;
  public String uid = null;
  public CryptoParams params = null;
  public byte[] data = null;
  public byte[] corr = null;
  public Boolean initInd = null;
  public Boolean finalInd = null;

  public TemplateAttribute template = new TemplateAttribute();

  public int derivationMethod = 0;
  public byte[] iv = null;
  public byte[] derivationData = null;
  public byte[] salt = null;
  public Integer iterationCount = null;

  public DeriveRequest()
  {
    super(KMIP.Operation.DeriveKey);
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    objectType = converter.convert(KMIP.Tag.ObjectType, objectType);
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    derivationMethod = converter.convert(KMIP.Tag.DerivationMethod, derivationMethod);
    int begin = converter.convertBegin(KMIP.Tag.DerivationParameters);
    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters)
      params = new CryptoParams();
    if (params != null) params.convertValue(converter);
    iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, iv);
    derivationData = converter.convertOptional(KMIP.Tag.DerivationData, derivationData);
    salt = converter.convertOptional(KMIP.Tag.Salt, salt);
    iterationCount = converter.convertOptional(KMIP.Tag.IterationCount, iterationCount);
    converter.convertEnd(begin);
    template.convert(converter);
  }

}
