package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class DeleteAttributeRequest extends RequestItem
{
  public String uid = null;
  public String name = null;
  public Integer index = null;

  public DeleteAttributeRequest()
  {
    super(KMIP.Operation.DeleteAttribute);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    name = converter.convert(KMIP.Tag.AttributeName, name);
    index = converter.convertOptional(KMIP.Tag.AttributeIndex, index);
  }

}
