package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class CreateRequest extends RequestItem
{
  public int objectType = 0;

  public TemplateAttribute template = new TemplateAttribute();

  public CreateRequest()
  {
    super(KMIP.Operation.Create);
  }

  public CreateRequest(int operation)
  {
    super(operation);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    objectType = converter.convert(KMIP.Tag.ObjectType, objectType);

    if (!converter.isWrite())
    {
      int tag = converter.getNextTag();
      if (tag == KMIP.Tag.CommonTemplateAttribute ||
              tag == KMIP.Tag.PrivateKeyTemplateAttribute ||
              tag == KMIP.Tag.PublicKeyTemplateAttribute ||
              tag == KMIP.Tag.TemplateAttribute) template = new TemplateAttribute();
    }

    if (template != null) template.convert(converter);
  }

}
