package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;
import com.unbound.provider.kmip.attribute.TemplateAttribute;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class

CreateKeyPairRequest extends RequestItem
{
  public TemplateAttribute common = null;

  public TemplateAttribute prv = null;

  public TemplateAttribute pub = null;


  public CreateKeyPairRequest()
  {
    super(KMIP.Operation.CreateKeyPair);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    if (converter.isRead() && converter.getNextTag() == KMIP.Tag.CommonTemplateAttribute)
      common = new TemplateAttribute();
    if (common != null)
    {
      common.tag = KMIP.Tag.CommonTemplateAttribute;
      common.convert(converter);
    }
    if (converter.isRead() && converter.getNextTag() == KMIP.Tag.PrivateKeyTemplateAttribute)
      prv = new TemplateAttribute();
    if (prv != null)
    {
      prv.tag = KMIP.Tag.PrivateKeyTemplateAttribute;
      prv.convert(converter);
    }
    if (converter.isRead() && converter.getNextTag() == KMIP.Tag.PublicKeyTemplateAttribute)
      pub = new TemplateAttribute();
    if (pub != null)
    {
      pub.tag = KMIP.Tag.PublicKeyTemplateAttribute;
      pub.convert(converter);
    }
  }

  public void addCommonAttribute(Attribute attribute)
  {
    if (common == null)
      common = new TemplateAttribute(KMIP.Tag.CommonTemplateAttribute);
    common.attrs.add(attribute);
  }

  public void addPublicKeyAttribute(Attribute attribute)
  {
    if (pub == null)
      pub = new TemplateAttribute(KMIP.Tag.PublicKeyTemplateAttribute);
    pub.attrs.add(attribute);
  }

  public void addPrivateKeyAttribute(Attribute attribute)
  {
    if (prv == null)
      prv = new TemplateAttribute(KMIP.Tag.PrivateKeyTemplateAttribute);
    prv.attrs.add(attribute);
  }

}
