package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 23-Nov-15.
 */
public class CheckRequest extends RequestItem
{
  public String uid = null;

  public Long usageLimitsCount = null;
  public Integer cryptoUsageMask = null;
  public Integer leaseTime = null;

  public CheckRequest()
  {
    super(KMIP.Operation.Check);
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    usageLimitsCount = converter.convertOptional(KMIP.Tag.UsageLimitsCount, usageLimitsCount);
    cryptoUsageMask = converter.convertOptional(KMIP.Tag.CryptographicUsageMask, cryptoUsageMask);
    leaseTime = converter.convertOptional(KMIP.Tag.LeaseTime, leaseTime);
  }
}
