package com.unbound.provider.kmip.request;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

/**
 * Created by valery.osheter on 25-Nov-15.
 */
public class AddAttributeRequest extends RequestItem
{

  public String uid = null;
  public Attribute attribute = null;

  public AddAttributeRequest()
  {
    super(KMIP.Operation.AddAttribute);
  }

  public AddAttributeRequest(String uid, Attribute attribute)
  {
    this();
    this.uid = uid;
    this.attribute = attribute;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
    attribute = Attribute.convert(converter, attribute);
  }
}
