package com.unbound.provider.kmip.request;


import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 23-Nov-15.
 */
public class ActivateRequest extends RequestItem
{
  public String uid = null;

  public ActivateRequest()
  {
    super(KMIP.Operation.Activate);
  }

  public ActivateRequest(String uid)
  {
    this();
    this.uid = uid;
  }

  @Override
  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, uid);
  }
}
