package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attributes;
import com.unbound.provider.kmip.attribute.Name;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class Template extends ManagedObject
{

  public Name name = null;
  public Attributes attrs = new Attributes();

  public Template()
  {
    super(KMIP.Tag.Template);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.Template);
    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.Name) name = new Name();
    if (name != null) name.convertValue(converter);
    attrs.convert(converter);
    converter.convertEnd(begin);
  }

  public int getKMIPObjectType()
  {
    return KMIP.ObjectType.Template;
  }

}
