package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class SymmetricKey extends ManagedObject
{
  public KeyBlock keyBlock = new KeyBlock();

  public SymmetricKey()
  {
    super(KMIP.Tag.SymmetricKey);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.SymmetricKey);
    keyBlock.convert(converter);
    converter.convertEnd(begin);
  }

  public int getKMIPObjectType()
  {
    return KMIP.ObjectType.SymmetricKey;
  }

}
