package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class SecretData extends ManagedObject
{
  public KeyBlock keyBlock = new KeyBlock();
  public int type = 0;

  public SecretData()
  {
    super(KMIP.Tag.SecretData);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.SecretData);
    type = converter.convert(KMIP.Tag.SecretDataType, type);
    keyBlock.convert(converter);
    converter.convertEnd(begin);
  }

  public int getKMIPObjectType()
  {
    return KMIP.ObjectType.SecretData;
  }

}
