package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class PGPKey extends ManagedObject
{
  Integer version = null;
  public KeyBlock keyBlock = new KeyBlock();

  public PGPKey()
  {
    super(KMIP.Tag.PGPKey);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(tag);
    keyBlock.convert(converter);
    version = converter.convert(KMIP.Tag.PGPKeyVersion, version);
    converter.convertEnd(begin);
  }

  public int getKMIPObjectType()
  {
    return KMIP.ObjectType.PGPKey;
  }

}
