package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class OpaqueObject extends ManagedObject
{
    public int type = 0;
    public byte[] value = null;
    public OpaqueObject() {
        super(KMIP.Tag.OpaqueObject);
    }

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.OpaqueObject);
        type = converter.convert(KMIP.Tag.OpaqueDataType, type);
        value = converter.convert(KMIP.Tag.OpaqueDataValue, value);
        converter.convertEnd(begin);
    }

    public int getKMIPObjectType() {
        return KMIP.ObjectType.OpaqueObject;
    }

}
