package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public abstract class ManagedObject
{
  public int tag;

  public ManagedObject(int _tag)
  {
    tag = _tag;
  }

  public abstract void convert(KMIPConverter converter) throws KMIPConvertException;

  public static ManagedObject create(int tag) throws KMIPConvertException
  {
    if (tag == KMIP.Tag.Certificate) return new Certificate();
    if (tag == KMIP.Tag.SymmetricKey) return new SymmetricKey();
    if (tag == KMIP.Tag.PrivateKey) return new PrivateKey();
    if (tag == KMIP.Tag.PublicKey) return new PublicKey();
    if (tag == KMIP.Tag.SecretData) return new SecretData();
    if (tag == KMIP.Tag.OpaqueObject) return new OpaqueObject();
    if (tag == KMIP.Tag.Template) return new Template();
    if (tag == KMIP.Tag.PGPKey) return new PGPKey();
    KMIPConverter.setError("Unexpected ManagedObject type " + tag);
    return null;
  }

  abstract public int getKMIPObjectType();
}
