package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attributes;
import com.unbound.provider.kmip.attribute.KeyWrappingData;

import java.math.BigInteger;

/**
 * Created by valery.osheter on 29-Nov-15.
 */
public class KeyBlock
{
  public int formatType = 0;
  public Integer compressionType = null;
  public Integer algorithm = null;
  public Integer length = null;
  public Attributes attrs = new Attributes();
  public byte[] buf = null;
  public BigInteger N = null;
  public BigInteger E = null;
  public BigInteger D = null;
  public BigInteger P = null;
  public BigInteger Q = null;
  public BigInteger DP = null;
  public BigInteger DQ = null;
  public BigInteger QINV = null;
  public Integer curveType = null;
  public byte[] ecPoint = null;
  public boolean bufKeyMaterial;
  public KeyWrappingData keyWrap = null;
  public byte[] limaPrvKey = null;
  public byte[] limaPubKey = null;
  public int limaType = 0;

  public boolean isTransparentFormat()
  {
    return
      formatType == KMIP.KeyFormatType.TransparentSymmetricKey ||
      formatType == KMIP.KeyFormatType.TransparentDHPrivateKey ||
      formatType == KMIP.KeyFormatType.TransparentDHPublicKey ||
      formatType == KMIP.KeyFormatType.TransparentDSAPrivateKey ||
      formatType == KMIP.KeyFormatType.TransparentDSAPublicKey ||
      formatType == KMIP.KeyFormatType.TransparentECDHPrivateKey ||
      formatType == KMIP.KeyFormatType.TransparentECDHPublicKey ||
      formatType == KMIP.KeyFormatType.TransparentECDSAPrivateKey ||
      formatType == KMIP.KeyFormatType.TransparentECDSAPublicKey ||
      formatType == KMIP.KeyFormatType.TransparentECMQVPrivateKey ||
      formatType == KMIP.KeyFormatType.TransparentECMQVPublicKey ||
      formatType == KMIP.KeyFormatType.TransparentECPrivateKey ||
      formatType == KMIP.KeyFormatType.TransparentECPublicKey ||
      formatType == KMIP.KeyFormatType.TransparentRSAPrivateKey ||
      formatType == KMIP.KeyFormatType.TransparentRSAPublicKey;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.KeyBlock);
    formatType = converter.convert(KMIP.Tag.KeyFormatType, formatType);
    compressionType = converter.convertOptional(KMIP.Tag.KeyCompressionType, compressionType);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.KeyValueBuf) keyWrap = new KeyWrappingData();

    if (keyWrap != null)
    {
      bufKeyMaterial = true;
      buf = converter.convert(KMIP.Tag.KeyValueBuf, buf);
    }
    else
    {
      bufKeyMaterial =
        formatType == KMIP.KeyFormatType.Raw ||
        formatType == KMIP.KeyFormatType.Opaque ||
        formatType == KMIP.KeyFormatType.PKCS_1 ||
        formatType == KMIP.KeyFormatType.PKCS_8 ||
        formatType == KMIP.KeyFormatType.X_509 ||
        formatType == KMIP.KeyFormatType.PUBLIC_PEM ||
        formatType == KMIP.KeyFormatType.PFX ||
        formatType == KMIP.KeyFormatType.ECPrivateKey;

      int valueBegin = converter.convertBegin(KMIP.Tag.KeyValueStruct);
      if (bufKeyMaterial)
        buf = converter.convert(KMIP.Tag.KeyMaterialBuf, buf);
      else
      {
        int matBegin = converter.convertBegin(KMIP.Tag.KeyMaterialStruct);

        switch (formatType)
        {
          case KMIP.KeyFormatType.TransparentSymmetricKey:
            buf = converter.convert(KMIP.Tag.Key, buf);
            break;

          case KMIP.KeyFormatType.TransparentRSAPublicKey:
            N = converter.convert(KMIP.Tag.Modulus, N);
            E = converter.convert(KMIP.Tag.PublicExponent, E);
            break;

          case KMIP.KeyFormatType.TransparentRSAPrivateKey:
            N = converter.convert(KMIP.Tag.Modulus, N);
            D = converter.convert(KMIP.Tag.PrivateExponent, D);
            E = converter.convertOptional(KMIP.Tag.PublicExponent, E);
            P = converter.convertOptional(KMIP.Tag.P, P);
            Q = converter.convertOptional(KMIP.Tag.Q, Q);
            DP = converter.convertOptional(KMIP.Tag.PrimeExponentP, DP);
            DQ = converter.convertOptional(KMIP.Tag.PrimeExponentQ, DQ);
            QINV = converter.convertOptional(KMIP.Tag.CRTCoefficient, QINV);
            break;

          case KMIP.KeyFormatType.TransparentECPrivateKey:
          case KMIP.KeyFormatType.TransparentECDSAPrivateKey:
          case KMIP.KeyFormatType.TransparentECDHPrivateKey:
            curveType = converter.convert(KMIP.Tag.RecommendedCurve, curveType);
            D = converter.convert(KMIP.Tag.D, D);
            break;

          case KMIP.KeyFormatType.TransparentECPublicKey:
          case KMIP.KeyFormatType.TransparentECDSAPublicKey:
          case KMIP.KeyFormatType.TransparentECDHPublicKey:
            curveType = converter.convert(KMIP.Tag.RecommendedCurve, curveType);
            ecPoint = converter.convert(KMIP.Tag.QString, ecPoint);
            break;

          case KMIP.KeyFormatType.TransparentLIMAPrivateKey:
            limaType = converter.convert(KMIP.Tag.DyLIMAKeyType, limaType);
            limaPrvKey = converter.convert(KMIP.Tag.DyLIMAPrivateKey, limaPrvKey);
            limaPubKey = converter.convert(KMIP.Tag.DyLIMAPrivateKey, limaPubKey);
            break;
        }

        converter.convertEnd(matBegin);
      }
      attrs.convert(converter);
      converter.convertEnd(valueBegin);
    }

    algorithm = converter.convertOptional(KMIP.Tag.CryptographicAlgorithm, algorithm);
    length = converter.convertOptional(KMIP.Tag.CryptographicLength, length);

    if (keyWrap != null) keyWrap.convert(converter);

    converter.convertEnd(begin);
  }
}
