package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class Certificate extends ManagedObject
{
  public byte[] value = null;
  public int type = 0;
  public int formatType = 0;
  public String password;
  public String uid;
  public String name;

  public Certificate()
  {
    super(KMIP.Tag.Certificate);
  }

  public Certificate(byte[] value)
  {
    super(KMIP.Tag.Certificate);
    this.value = value;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.Certificate);
    type = converter.convert(KMIP.Tag.CertificateType, type);
    value = converter.convert(KMIP.Tag.CertificateValue, value);
    converter.convertEnd(begin);
  }

  public int getKMIPObjectType()
  {
    return KMIP.ObjectType.Certificate;
  }

}
