package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class X509CertificateIssuer extends Attribute
{
  public byte[] name = null;
  public byte[] alternativeName = null;

  public X509CertificateIssuer()
  {
    super(KMIP.Tag.X509CertificateIssuer);
  }

  public X509CertificateIssuer(byte[] name, byte[] alternativeName)
  {
    this();
    this.name = name;
    this.alternativeName = alternativeName;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    name = converter.convert(KMIP.Tag.IssuerDistinguishedName, name);
    alternativeName = converter.convertOptional(KMIP.Tag.IssuerAlternativeName, alternativeName);
    converter.convertEnd(begin);
  }
}
