package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class X509CertificateID extends Attribute
{

  public byte[] issuer = null;
  public byte[] serialNumber = null;

  public X509CertificateID()
  {
    super(KMIP.Tag.X509CertificateIdentifier);
  }

  public X509CertificateID(byte[] issuer, byte[] serialNumber)
  {
    this();
    this.issuer = issuer;
    this.serialNumber = serialNumber;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    issuer = converter.convert(KMIP.Tag.IssuerDistinguishedName, issuer);
    serialNumber = converter.convert(KMIP.Tag.CertificateSerialNumber, serialNumber);
    converter.convertEnd(begin);
  }
}
