package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

public class UsageLimits extends Attribute
{
  public long total = 0;
  public Long count = null;
  public int unit = 0;

  public UsageLimits()
  {
    super(KMIP.Tag.UsageLimits);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    total = converter.convert(KMIP.Tag.UsageLimitsTotal, total);
    count = converter.convertOptional(KMIP.Tag.UsageLimitsCount, count);
    unit = converter.convert(KMIP.Tag.UsageLimitsUnit, unit);
    converter.convertEnd(begin);
  }

}
