package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 05-Oct-16.
 */
public class TextAttribute extends Attribute
{
  String value;

  public TextAttribute(int tag)
  {
    super(tag);
  }

  public TextAttribute(int tag, String value)
  {
    super(tag);
    this.value = value;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    String v = (converter.isWrite() && value == null) ? "" : value;
    value = converter.convert(KMIP.tagAttributeValue(KMIP.TagType.TextString), value);
  }
}
