package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class TemplateAttribute
{
  public int tag = KMIP.Tag.TemplateAttribute;

  public Name name = null;
  public Attributes attrs = new Attributes();


  public TemplateAttribute()
  {
  }

  public TemplateAttribute(int _tag)
  {
    tag = _tag;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    if (converter.isRead())
    {
      tag = converter.getNextTag();
      if (tag == 0) KMIPConverter.setError("Template conversion error");
    }
    int begin = converter.convertBegin(tag);
    if (converter.isRead() && converter.getNextTag() == KMIP.Tag.Name) name = new Name();
    if (name != null) name.convertValue(converter);
    attrs.convert(converter);
    converter.convertEnd(begin);
  }

}
