package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;

/**
 * Created by valery.osheter on 26-Nov-15.
 */
public class ServerInfo
{
  public String version = "2.0";
  public String serverName = "";
  public String clientName = "";
  public String roleName = "";
  public String currentPartition = "";
  public Long lastActivity;
  public ArrayList<String> partitions = new ArrayList<>();
  public ArrayList<Integer> algs = new ArrayList<Integer>();
  public ArrayList<Integer> signAlgs = new ArrayList<Integer>();
  public ArrayList<Integer> hashAlgs = new ArrayList<Integer>();
  public ArrayList<Integer> blockCipherNodes = new ArrayList<Integer>();
  public ArrayList<Integer> paddings = new ArrayList<Integer>();

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.ServerInformation);
    converter.convert(KMIP.Tag.DyPartition, currentPartition);
    converter.convert(KMIP.Tag.DyClient, clientName);
    converter.convert(KMIP.Tag.DyServerName, serverName);
    converter.convertStrList(KMIP.Tag.DyPartitionName, partitions);
    converter.convertIntList(KMIP.Tag.CryptographicAlgorithm, algs);
    converter.convertIntList(KMIP.Tag.DigitalSignatureAlgorithm, signAlgs);
    converter.convertIntList(KMIP.Tag.HashingAlgorithm, hashAlgs);
    converter.convertIntList(KMIP.Tag.BlockCipherMode, blockCipherNodes);
    converter.convertIntList(KMIP.Tag.PaddingMethod, paddings);
    converter.convertOptional(KMIP.Tag.DyVersion, version);
    converter.convertOptional(KMIP.Tag.DyLastActivity, lastActivity);
    converter.convertOptional(KMIP.Tag.DyRole, roleName);
    converter.convertEnd(begin);
  }
}
