package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class RevocationReason extends Attribute
{

  public int code = 0;
  public String message = null;

  public RevocationReason()
  {
    super(KMIP.Tag.RevocationReason);
  }

  public RevocationReason(int reason)
  {
    this();
    this.code = reason;
  }

  public void convertValue(KMIPConverter converter, int tag) throws KMIPConvertException
  {
    int begin = converter.convertBegin(tag);
    code = converter.convert(KMIP.Tag.RevocationReasonCode, code);
    message = converter.convertOptional(KMIP.Tag.RevocationMessage, message);
    converter.convertEnd(begin);
  }

  public void convertValue(KMIPConverter converter) throws KMIPConvertException
  {
    convertValue(converter, KMIP.Tag.RevocationReason);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    convertValue(converter, KMIP.tagAttributeValue(KMIP.TagType.Structure));
  }
}
