package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

public class RNGParams extends Attribute
{

  public Integer rngAlg = null;
  public Integer cryptoAlg = null;
  public Integer cryptoLen = null;
  public Integer hashAlg = null;
  public Integer drbgAlg = null;
  public Integer curve = null;
  public Integer fips186Var = null;
  public Boolean predictResist = null;

  public RNGParams()
  {
    super(KMIP.Tag.RNGParameters);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    convertValue(converter, KMIP.tagAttributeValue(KMIP.TagType.Structure));
  }

  public void convertValue(KMIPConverter converter) throws KMIPConvertException
  {
    convertValue(converter, KMIP.Tag.CryptographicParameters);
  }

  public void convertValue(KMIPConverter converter, int tag) throws KMIPConvertException
  {
    int begin = converter.convertBegin(tag);
    rngAlg = converter.convert(KMIP.Tag.RNGAlgorithm, rngAlg);
    cryptoAlg = converter.convertOptional(KMIP.Tag.CryptographicAlgorithm, cryptoAlg);
    cryptoLen = converter.convertOptional(KMIP.Tag.CryptographicLength, cryptoLen);
    hashAlg = converter.convertOptional(KMIP.Tag.HashingAlgorithm, hashAlg);
    drbgAlg = converter.convertOptional(KMIP.Tag.DRBGAlgorithm, drbgAlg);
    curve = converter.convertOptional(KMIP.Tag.RecommendedCurve, curve);
    fips186Var = converter.convertOptional(KMIP.Tag.FIPS186Variation, fips186Var);
    predictResist = converter.convertOptional(KMIP.Tag.PredictionResistance, predictResist);
    converter.convertEnd(begin);
  }

}
