package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 18-Nov-15.
 */
public class Name extends Attribute
{

  public String value = null;
  public int type = KMIP.NameType.UninterpretedTextString;

  public Name()
  {
    super(KMIP.Tag.Name);
  }

  public Name(String value)
  {
    this();
    this.value = value;
  }

  public Name(String value, int type)
  {
    this(value);
    this.type = type;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    value = converter.convert(KMIP.Tag.NameValue, value);
    type = converter.convert(KMIP.Tag.NameType, type);
    converter.convertEnd(begin);
  }

  public void convertValue(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.Name);
    value = converter.convert(KMIP.Tag.NameValue, value);
    type = converter.convert(KMIP.Tag.NameType, type);
    converter.convertEnd(begin);
  }
}
