package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class MessageExt
{
  public String vendorId = null;
  public Boolean critical = null;

  public ArrayList<byte[]> auth = new ArrayList<byte[]>();
  public Integer mgf = null;
  public Integer pssSaltSize = null;
  public byte[] iv = null;
  public Integer dataLength = null;


  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.MessageExtension);
    vendorId = converter.convert(KMIP.Tag.VendorIdentification, vendorId);
    critical = converter.convert(KMIP.Tag.CriticalityIndicator, critical);
    {
      int vendorBegin = converter.convertBegin(KMIP.Tag.VendorExtension);
      if (auth != null) converter.convertBufList(KMIP.Tag.DyAuth, auth);
      mgf = converter.convertOptional(KMIP.Tag.DyMgfAlg, mgf);
      pssSaltSize = converter.convertOptional(KMIP.Tag.DyPssSaltSize, pssSaltSize);
      iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, iv);
      dataLength = converter.convertOptional(KMIP.Tag.DataLength, dataLength);
      converter.convertEnd(vendorBegin);
    }
    converter.convertEnd(begin);
  }
}
