package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by saar.peer on 15-Feb-17.
 */
public class Link extends Attribute
{

  public int type;
  public String id;

  public Link()
  {
    super(KMIP.Tag.Link);
  }

  public Link(int type, String id)
  {
    this();
    this.type = type;
    this.id = id;
  }

  public Link(int type)
  {
    this();
    this.type = type;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    type = converter.convert(KMIP.Tag.LinkType, type);
    id = converter.convert(KMIP.Tag.LinkedObjectIdentifier, id);
    converter.convertEnd(begin);
  }

  public void convertValue(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.Link);
    type = converter.convert(KMIP.Tag.LinkType, type);
    id = converter.convert(KMIP.Tag.LinkedObjectIdentifier, id);
    converter.convertEnd(begin);
  }
}
