package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.ArrayList;

/**
 * Created by valery.osheter on 14-Nov-16.
 */
public class KeyWrappingSpec
{
  public int wrapping_method = 0;
  public KeyWrappingInfo encKey = null;
  public KeyWrappingInfo macKey = null;
  public ArrayList<String> attrNames = new ArrayList<String>();
  public Integer encodingOption = null;

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.KeyWrappingSpecification);
    wrapping_method = converter.convert(KMIP.Tag.WrappingMethod, wrapping_method);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.EncryptionKeyInformation)
      encKey = new KeyWrappingInfo();
    if (encKey != null)
    {
      int b = converter.convertBegin(KMIP.Tag.EncryptionKeyInformation);
      encKey.convert(converter);
      converter.convertEnd(b);
    }

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.MacSignatureKeyInformation)
      macKey = new KeyWrappingInfo();
    if (macKey != null)
    {
      int b = converter.convertBegin(KMIP.Tag.MacSignatureKeyInformation);
      macKey.convert(converter);
      converter.convertEnd(b);
    }

    converter.convertStrList(KMIP.Tag.AttributeName, attrNames);
    encodingOption = converter.convertOptional(KMIP.Tag.EncodingOption, encodingOption);

    converter.convertEnd(begin);
  }

}
