package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 14-Nov-16.
 */
public class KeyWrappingInfo
{
  public String uid = null;
  public CryptoParams params = null;

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    uid = converter.convert(KMIP.Tag.UniqueIdentifier, uid);
    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters)
      params = new CryptoParams();
    if (params != null) params.convertValue(converter);
  }
}
