package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 14-Nov-16.
 */
public class KeyWrappingData extends Attribute
{
  public int wrapping_method = 0;
  public KeyWrappingInfo encKey = null;
  public KeyWrappingInfo macKey = null;
  public byte[] mac = null;
  public byte[] iv = null;
  public Integer encodingOption = null;

  public KeyWrappingData()
  {
    super(KMIP.Tag.KeyWrappingData);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.KeyWrappingData);
    wrapping_method = converter.convert(KMIP.Tag.WrappingMethod, wrapping_method);

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.EncryptionKeyInformation)
      encKey = new KeyWrappingInfo();
    if (encKey != null)
    {
      int b = converter.convertBegin(KMIP.Tag.EncryptionKeyInformation);
      encKey.convert(converter);
      converter.convertEnd(b);
    }

    if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.MacSignatureKeyInformation)
      macKey = new KeyWrappingInfo();
    if (macKey != null)
    {
      int b = converter.convertBegin(KMIP.Tag.MacSignatureKeyInformation);
      macKey.convert(converter);
      converter.convertEnd(b);
    }

    mac = converter.convertOptional(KMIP.Tag.MacSignature, mac);
    iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, iv);
    encodingOption = converter.convertOptional(KMIP.Tag.EncodingOption, encodingOption);

    converter.convertEnd(begin);
  }

}
