package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 05-Oct-16.
 */
public class Int64Attribute extends Attribute
{
  long value;

  public Int64Attribute(int tag)
  {
    super(tag);
  }

  public Int64Attribute(int tag, long value)
  {
    super(tag);
    this.value = value;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    value = converter.convert(KMIP.tagAttributeValue(KMIP.TagType.LongInteger), value);
  }
}
