package com.unbound.provider.kmip.attribute;


import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 05-Oct-16.
 */
public class EnumAttribute extends Attribute
{

  public int value = 0;

  public EnumAttribute()
  {

  }

  public EnumAttribute(int tag)
  {
    super(tag);
  }

  public EnumAttribute(int tag, int value)
  {
    super(tag);
    this.value = value;
  }

  public EnumAttribute(int tag, Integer value)
  {
    this(tag, value != null ? value : 0);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    value = converter.convert(KMIP.tagAttributeValue(KMIP.TagType.Enumeration), value, tag);
  }
}
