package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class Digest extends Attribute
{

  public int hashingAlg = 0;
  public byte[] value = null;
  public Integer keyFormat = null;

  public Digest()
  {
    super(KMIP.Tag.Digest);
  }

  public Digest(byte[] value, int hashingAlg, Integer keyFormat)
  {
    this();
    this.value = value;
    this.hashingAlg = hashingAlg;
    this.keyFormat = keyFormat;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    hashingAlg = converter.convert(KMIP.Tag.HashingAlgorithm, hashingAlg);
    value = converter.convertOptional(KMIP.Tag.DigestValue, value);
    keyFormat = converter.convertOptional(KMIP.Tag.KeyFormatType, keyFormat);
    converter.convertEnd(begin);
  }
}
