package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.time.Instant;

/**
 * Created by valery.osheter on 05-Oct-16.
 */
public class DateAttribute extends Attribute
{
  public long value = -1;

  public DateAttribute(int tag)
  {
    super(tag);
  }

  public DateAttribute(int tag, long val)
  {
    super(tag);
    value = val;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    value = converter.convert(KMIP.tagAttributeValue(KMIP.TagType.DateTime), value);
  }
}
