package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class CryptoParams extends Attribute
{

  public Integer mode = null;
  public Integer padding = null;
  public Integer hashingAlg = null;
  public Integer keyRole = null;
  public Integer signingAlg = null;
  public Integer cryptoAlg = null;
  public Boolean randomIv = null;
  public Integer ivLength = null;
  public Integer tagLength = null;
  public Integer fixFieldLength = null;
  public Integer invocationFieldLength = null;
  public Integer counterLength = null;
  public Integer initCounterValue = null;
  //kmip 1.4
  public Integer saltLength = null;
  public Integer maskGenerator = null;
  public Integer maskGeneratorHashAlg = null;
  public byte[] PSource = null;
  public Integer trailerField = null;

  public CryptoParams()
  {
    super(KMIP.Tag.CryptographicParameters);
  }

  public CryptoParams(Integer mode)
  {
    this();
    if (mode != 0) this.mode = mode;
  }

  public CryptoParams(Integer cryptoAlg, Integer mode, Integer padding)
  {
    this(mode);

    if (cryptoAlg != 0) this.cryptoAlg = cryptoAlg;
    if (padding != 0) this.padding = padding;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    convertValue(converter, KMIP.tagAttributeValue(KMIP.TagType.Structure));
  }

  public void convertValue(KMIPConverter converter) throws KMIPConvertException
  {
    convertValue(converter, KMIP.Tag.CryptographicParameters);
  }

  public void convertValue(KMIPConverter converter, int tag) throws KMIPConvertException
  {
    int begin = converter.convertBegin(tag);
    mode = converter.convertOptional(KMIP.Tag.BlockCipherMode, mode);
    padding = converter.convertOptional(KMIP.Tag.PaddingMethod, padding);
    hashingAlg = converter.convertOptional(KMIP.Tag.HashingAlgorithm, hashingAlg);
    keyRole = converter.convertOptional(KMIP.Tag.KeyRoleType, keyRole);
    signingAlg = converter.convertOptional(KMIP.Tag.DigitalSignatureAlgorithm, signingAlg);
    cryptoAlg = converter.convertOptional(KMIP.Tag.CryptographicAlgorithm, cryptoAlg);
    randomIv = converter.convertOptional(KMIP.Tag.RandomIV, randomIv);
    ivLength = converter.convertOptional(KMIP.Tag.IVLength, ivLength);
    tagLength = converter.convertOptional(KMIP.Tag.TagLength, tagLength);
    fixFieldLength = converter.convertOptional(KMIP.Tag.FixedFieldLength, fixFieldLength);
    invocationFieldLength = converter.convertOptional(KMIP.Tag.InvocationFieldLength, invocationFieldLength);
    counterLength = converter.convertOptional(KMIP.Tag.CounterLength, counterLength);
    initCounterValue = converter.convertOptional(KMIP.Tag.InitialCounterValue, initCounterValue);

    saltLength = converter.convertOptional(KMIP.Tag.SaltLength, saltLength);
    maskGenerator = converter.convertOptional(KMIP.Tag.MaskGenerator, maskGenerator);
    maskGeneratorHashAlg = converter.convertOptional(KMIP.Tag.MaskGeneratorHashingAlgorithm, maskGeneratorHashAlg);
    PSource = converter.convertOptional(KMIP.Tag.PSource, PSource);
    trailerField = converter.convertOptional(KMIP.Tag.TrailerField, trailerField);

    converter.convertEnd(begin);
  }
}
