package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class CryptoDomainParams extends Attribute
{

  public Integer qLength = null;
  public Integer curveType = null;

  public CryptoDomainParams()
  {
    super(KMIP.Tag.CryptographicDomainParameters);
  }

  public CryptoDomainParams(Integer qLength, Integer curveType)
  {
    super(KMIP.Tag.CryptographicDomainParameters);
    this.qLength = qLength;
    this.curveType = curveType;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    qLength = converter.convertOptional(KMIP.Tag.QLength, qLength);
    curveType = converter.convertOptional(KMIP.Tag.RecommendedCurve, curveType);
    converter.convertEnd(begin);
  }
}
