package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class CertificateSubject extends Attribute
{

  public String name = null;
  public String alternativeName = null;

  public CertificateSubject()
  {
    super(KMIP.Tag.CertificateSubject);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    name = converter.convert(KMIP.Tag.CertificateSubjectDistinguishedName, name);
    alternativeName = converter.convertOptional(KMIP.Tag.CertificateSubjectAlternativeName, alternativeName);
    converter.convertEnd(begin);
  }

}
