package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class CertificateIssuer extends Attribute
{

  public String name = null;
  public String alternativeName = null;

  public CertificateIssuer()
  {
    super(KMIP.Tag.CertificateIssuer);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    name = converter.convert(KMIP.Tag.CertificateIssuerDistinguishedName, name);
    alternativeName = converter.convertOptional(KMIP.Tag.CertificateIssuerAlternativeName, alternativeName);
    converter.convertEnd(begin);
  }
}
