package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class CertificateID extends Attribute
{

  public String issuer = null;
  public String serialNumber = null;

  public CertificateID()
  {
    super(KMIP.Tag.CertificateIssuer);
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    issuer = converter.convert(KMIP.Tag.Issuer, issuer);
    serialNumber = converter.convert(KMIP.Tag.SerialNumber, serialNumber);
    converter.convertEnd(begin);
  }

}
