package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

public class CapabilityInformation
{
  Boolean streamingCapability = false;
  Boolean asynchronousCapability = false;
  Boolean attestationCapability = false;
  Boolean batchUndoCapability = false;
  Boolean batchContinueCapability = false;
  Integer unwrapMode = KMIP.UnwrapMode.Unspecified;
  Integer destroyAction = KMIP.DestroyAction.Unspecified;
  Integer shreddingAlgorithm = KMIP.ShreddingAlgorithm.Unspecified;
  Integer RNGMode = KMIP.RNGMode.Unspecified;

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.CapabilityInformation);
    streamingCapability = converter.convertOptional(KMIP.Tag.StreamingCapability, streamingCapability);
    asynchronousCapability = converter.convertOptional(KMIP.Tag.AsynchronousCapability, asynchronousCapability);
    attestationCapability = converter.convertOptional(KMIP.Tag.AttestationCapability, attestationCapability);
    batchUndoCapability = converter.convertOptional(KMIP.Tag.BatchUndoCapability, batchUndoCapability);
    batchContinueCapability = converter.convertOptional(KMIP.Tag.BatchContinueCapability, batchContinueCapability);
    unwrapMode = converter.convertOptional(KMIP.Tag.UnwrapMode, unwrapMode);
    destroyAction = converter.convertOptional(KMIP.Tag.DestroyAction, destroyAction);
    shreddingAlgorithm = converter.convertOptional(KMIP.Tag.ShreddingAlgorithm, shreddingAlgorithm);
    RNGMode = converter.convertOptional(KMIP.Tag.RNGMode, RNGMode);
    converter.convertEnd(begin);
  }

}
