package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 05-Oct-16.
 */
public class BytesAttribute extends Attribute
{
  public byte[] value = new byte[0];

  public BytesAttribute(int tag)
  {
    super(tag);
  }

  public BytesAttribute(int tag, byte[] value)
  {
    super(tag);
    this.value = value;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    byte[] v = (converter.isWrite() && value == null) ? new byte[0] : value;
    value = converter.convert(KMIP.tagAttributeValue(KMIP.TagType.ByteString), v);
  }
}
