package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.math.BigInteger;
import java.util.Arrays;

/**
 * Created by valery.osheter on 05-Oct-16.
 */
public class BigNumAttribute extends Attribute
{
  public BigInteger value = null;

  public BigNumAttribute(int tag)
  {
    super(tag);
  }

  public BigNumAttribute(int tag, BigInteger value)
  {
    super(tag);
    this.value = value;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    value = converter.convert(KMIP.tagAttributeValue(KMIP.TagType.BigInteger), value);
  }

  public static byte[] toBin(BigInteger bn)
  {
    byte[] bin = bn.toByteArray();
    if (bin.length > 0 && bin[0] == 0) return Arrays.copyOfRange(bin, 1, bin.length);
    return bin;
  }

  public static byte[] toBin(BigInteger bn, int length)
  {
    byte[] bin = bn.toByteArray();
    int binOffset = 0;
    if (bin.length > 0 && bin[0] == 0) binOffset = 1;
    int size = bin.length - binOffset;
    if (length < size) throw new RuntimeException("BigInteger buffer too small");
    if (binOffset == 0 && length == size) return bin;
    if (binOffset == 1 && length == size + 1) return bin;
    byte[] result = new byte[length];
    System.arraycopy(bin, binOffset, result, length - size, size);
    return result;
  }

  public static int toBin(BigInteger bn, byte[] dst, int offset)
  {
    int size = binSize(bn);
    if (dst != null)
    {
      toBin(bn, dst, offset, size);
    }
    return size;
  }

  public static void toBin(BigInteger bn, byte[] dst, int offset, int length)
  {
    byte[] bin = bn.toByteArray();
    int binOffset = 0;
    if (bin.length > 0 && bin[0] == 0) binOffset = 1;
    int size = bin.length - binOffset;
    if (length < size) throw new RuntimeException("BigInteger buffer too small");
    for (int i = 0; i < length - size; i++) dst[offset++] = 0;
    System.arraycopy(bin, binOffset, dst, offset, size);
  }

  public static int binSize(BigInteger bn)
  {
    return (bn.bitLength() + 7) / 8;
  }

  public static BigInteger fromBin(byte[] bin, int offset, int length)
  {
    if (length == 0) return BigInteger.ZERO;
    if ((bin[offset] & 0x80) == 0)
    {
      if (offset == 0 && length == bin.length) return new BigInteger(1, bin);
      return new BigInteger(1, Arrays.copyOfRange(bin, offset, offset + length));
    }
    byte[] padded = new byte[length + 1];
    System.arraycopy(bin, offset, padded, 1, length);
    return new BigInteger(1, padded);
  }

  public static BigInteger fromBin(byte[] bin)
  {
    return fromBin(bin, 0, bin.length);
  }
}
