package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 19-Jan-17.
 */
public class Authentication
{

  public static Authentication trivialAuth;

  static
  {

    trivialAuth = new Authentication();
    trivialAuth.credType = KMIP.CredentialType.UsernameAndPassword;
    trivialAuth.username = "user";
    trivialAuth.password = "";
  }

  public static boolean isTrivialAuth(Authentication authentication)
  {
    if (authentication == null) return true;

    return
            trivialAuth.username.equals(authentication.username) &&
                    trivialAuth.password.equals(authentication.password);
  }

  public int credType;

  public String username = null;
  public String password = null;

  public Nonce nonce = new Nonce();
  public int attestationType;
  public byte[] attestationMeasurement = null;
  public byte[] attestationAssertion = null;

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.Tag.Authentication);
    int credBegin = converter.convertBegin(KMIP.Tag.Credential);
    credType = converter.convert(KMIP.Tag.CredentialType, credType);
    int credValueBegin = converter.convertBegin(KMIP.Tag.CredentialValue);
    if (credType == KMIP.CredentialType.UsernameAndPassword)
    {
      username = converter.convert(KMIP.Tag.Username, username);
      password = converter.convertOptional(KMIP.Tag.Password, password);
    }
    else if (credType == KMIP.CredentialType.Attestation)
    {
      nonce.convert(converter);
      attestationType = converter.convert(KMIP.Tag.AttestationType, attestationType);
      attestationMeasurement = converter.convertOptional(KMIP.Tag.AttestationMeasurement, attestationMeasurement);
      attestationAssertion = converter.convertOptional(KMIP.Tag.AttestationAssertion, attestationAssertion);
    }
    else KMIPConverter.setError("Unexpected credential type " + credType);
    converter.convertEnd(credValueBegin);
    converter.convertEnd(credBegin);
    converter.convertEnd(begin);
  }
}
