package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

import java.util.*;


/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class Attributes extends ArrayList<Attribute>
{

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    if (converter.isWrite())
    {
      for (Attribute attribute : this) Attribute.convert(converter, attribute);
    }
    else
    {
      while (converter.getNextTag() == KMIP.Tag.Attribute)
      {
        Attribute attribute = Attribute.convert(converter, null);
        add(attribute);
      }
    }
  }

  public Attribute find(int tag)
  {
    for (Attribute attribute : this)
    {
      if (attribute.tag == tag) return attribute;
    }
    return null;
  }

  public Attributes findAll(int tag)
  {
    Attributes attributes = new Attributes();
    for (Attribute attribute : this)
    {
      if (attribute.tag == tag) attributes.add(attribute);
    }
    return attributes;
  }

}
